/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ComponentInputMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.autoplot.AddPlotElementDialog;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUI;
import org.autoplot.AutoplotUtil;
import org.autoplot.ExportDataBundle;
import org.autoplot.ExportDataPanel;
import org.autoplot.ImportBookmarksGui;
import org.autoplot.ImportVapDialog;
import org.autoplot.PdfOptionsPanel;
import org.autoplot.PersistentStateSupport;
import org.autoplot.PlotStylePanel;
import org.autoplot.RenderType;
import org.autoplot.ScriptContext;
import org.autoplot.TcaElementDialog;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.bookmarks.BookmarksException;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.DataSourceFormatEditorPanel;
import org.autoplot.datasource.DataSourceRegistry;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.WindowManager;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.dom.Annotation;
import org.autoplot.dom.Application;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.Axis;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.Canvas;
import org.autoplot.dom.ChangesSupport;
import org.autoplot.dom.Column;
import org.autoplot.dom.Connector;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotController;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.Row;
import org.autoplot.layout.LayoutConstants;
import org.autoplot.renderer.AnnotationEditorPanel;
import org.autoplot.renderer.BoundsStylePanel;
import org.autoplot.renderer.ColorScatterStylePanel;
import org.autoplot.renderer.ContourStylePanel;
import org.autoplot.renderer.DigitalStylePanel;
import org.autoplot.renderer.EventsStylePanel;
import org.autoplot.renderer.HugeScatterStylePanel;
import org.autoplot.renderer.ImageStylePanel;
import org.autoplot.renderer.InternalStylePanel;
import org.autoplot.renderer.OrbitStylePanel;
import org.autoplot.renderer.PitchAngleDistributionStylePanel;
import org.autoplot.renderer.SeriesStylePanel;
import org.autoplot.renderer.SpectrogramStylePanel;
import org.autoplot.renderer.StackedHistogramStylePanel;
import org.autoplot.state.StatePersistence;
import org.autoplot.transferrable.ImageSelection;
import org.autoplot.util.GraphicsUtil;
import org.das2.DasApplication;
import org.das2.components.DasProgressPanel;
import org.das2.components.propertyeditor.EnumerationEditor;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.event.DasMouseInputAdapter;
import org.das2.event.DragRenderer;
import org.das2.event.MouseModule;
import org.das2.event.PointSlopeDragRenderer;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasPlot;
import org.das2.qds.DataSetOps;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.system.RequestProcessor;
import org.das2.util.Entities;
import org.das2.util.FontChooser;
import org.das2.util.LoggerManager;
import org.das2.util.awt.PdfGraphicsOutput;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.xml.sax.SAXException;

public class GuiSupport {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.guisupport");
    AutoplotUI parent;
    private static File currentFile;

    public GuiSupport(AutoplotUI parent) {
        this.parent = parent;
    }

    public void doPasteDataSetURL() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        if (contents == null) {
            logger.fine("contents was null");
            return;
        }
        boolean hasTransferableText = contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        String result = null;
        if (hasTransferableText) {
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        if (result != null) {
            this.parent.dataSetSelector.setValue(result);
        }
    }

    public void doCopyDataSetURL() {
        GuiSupport.setClipboard(DataSetURI.toUri((String)this.parent.dataSetSelector.getValue()).toString());
    }

    public static void setClipboard(String s) {
        StringSelection stringSelection = new StringSelection(s);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable contents) {
            }
        });
    }

    public void doCopyDataSetImage() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ImageSelection imageSelection = new ImageSelection();
                DasCanvas c = GuiSupport.this.parent.applicationModel.canvas;
                BufferedImage i = c.getImage(c.getWidth(), c.getHeight());
                imageSelection.setImage(i);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(imageSelection, new ClipboardOwner(){

                    @Override
                    public void lostOwnership(Clipboard clipboard, Transferable contents) {
                    }
                });
            }
        };
        new Thread(run, "CopyDataSetToClipboardThread").start();
    }

    public static Frame getFrameForComponent(Component parent) {
        if (!(parent instanceof Frame)) {
            parent = SwingUtilities.getWindowAncestor(parent);
        }
        if (parent instanceof Frame) {
            return (Frame)parent;
        }
        return null;
    }

    public static PlotStylePanel.StylePanel getStylePanel(RenderType renderType) {
        JPanel editorPanel;
        if (null == renderType) {
            SeriesStylePanel editorPanel2 = new SeriesStylePanel();
            return editorPanel2;
        }
        switch (renderType) {
            case spectrogram: 
            case nnSpectrogram: {
                editorPanel = new SpectrogramStylePanel();
                break;
            }
            case pitchAngleDistribution: {
                editorPanel = new PitchAngleDistributionStylePanel();
                break;
            }
            case polar: {
                editorPanel = new ColorScatterStylePanel();
                break;
            }
            case hugeScatter: {
                editorPanel = new HugeScatterStylePanel();
                break;
            }
            case colorScatter: {
                editorPanel = new ColorScatterStylePanel();
                break;
            }
            case contour: {
                editorPanel = new ContourStylePanel();
                break;
            }
            case internal: {
                editorPanel = new InternalStylePanel();
                break;
            }
            case bounds: {
                editorPanel = new BoundsStylePanel();
                break;
            }
            case digital: {
                editorPanel = new DigitalStylePanel();
                break;
            }
            case orbitPlot: {
                editorPanel = new OrbitStylePanel();
                break;
            }
            case eventsBar: {
                editorPanel = new EventsStylePanel();
                break;
            }
            case stackedHistogram: {
                editorPanel = new StackedHistogramStylePanel();
                break;
            }
            case image: {
                editorPanel = new ImageStylePanel();
                break;
            }
            default: {
                editorPanel = new SeriesStylePanel();
            }
        }
        return editorPanel;
    }

    public static void editPlotElement(ApplicationModel applicationModel, Component parent) {
        Application dom = applicationModel.dom;
        AddPlotElementDialog dia = new AddPlotElementDialog(GuiSupport.getFrameForComponent(parent), true);
        dia.getPrimaryDataSetSelector().setTimeRange(dom.getTimeRange());
        dia.getSecondaryDataSetSelector().setTimeRange(dom.getTimeRange());
        dia.getTertiaryDataSetSelector().setTimeRange(dom.getTimeRange());
        String suri = dom.getController().getFocusUri();
        GuiSupport.setAddPlotElementUris(applicationModel, dom, dia, suri);
        dia.setTitle("Editing Plot Element");
        WindowManager.getInstance().showModalDialog((Dialog)dia);
        if (dia.isCancelled()) {
            return;
        }
        GuiSupport.handleAddElementDialog(dia, dom, applicationModel);
    }

    private static void setAddPlotElementUris(ApplicationModel applicationModel, Application dom, AddPlotElementDialog dia, String suri) {
        Pattern hasKidsPattern = Pattern.compile("vap\\+internal\\:(data_\\d+)(,(data_\\d+))?+(,(data_\\d+))?+");
        Matcher m = hasKidsPattern.matcher(suri);
        dia.getPrimaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
        dia.getSecondaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
        dia.getTertiaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
        if (m.matches()) {
            int[] groups;
            int depCount = m.group(5) != null ? 2 : (m.group(3) != null ? 1 : (m.group(1) != null ? 0 : -1));
            dia.setDepCount(depCount);
            DataSetSelector[] selectors = new DataSetSelector[]{dia.getPrimaryDataSetSelector(), dia.getSecondaryDataSetSelector(), dia.getTertiaryDataSetSelector()};
            switch (depCount) {
                case 2: {
                    groups = new int[]{5, 1, 3};
                    break;
                }
                case 1: {
                    groups = new int[]{3, 1};
                    break;
                }
                default: {
                    groups = new int[]{1};
                }
            }
            for (int i = 0; i < groups.length; ++i) {
                DataSourceFilter dsf = (DataSourceFilter)DomUtil.getElementById(dom, m.group(groups[i]));
                if (dsf == null) {
                    selectors[i].setValue(m.group(groups[i]));
                    continue;
                }
                if (dsf.getUri().length() == 0) {
                    selectors[i].setValue(m.group(groups[i]));
                    continue;
                }
                if (dsf.getUri().startsWith("vap+internal:")) {
                    selectors[i].setValue(m.group(groups[i]));
                    continue;
                }
                selectors[i].setValue(dsf.getUri());
                dia.setFilter(i, dsf.getFilters());
            }
        } else {
            dia.getPrimaryDataSetSelector().setValue(suri);
        }
    }

    void addPlotElement(String title) {
        ApplicationModel applicationModel = this.parent.applicationModel;
        DataSetSelector dataSetSelector = this.parent.dataSetSelector;
        Application dom = applicationModel.dom;
        AddPlotElementDialog dia = new AddPlotElementDialog((Frame)this.parent, true);
        dia.getPrimaryDataSetSelector().setTimeRange(dom.getTimeRange());
        dia.getSecondaryDataSetSelector().setTimeRange(dom.getTimeRange());
        dia.getTertiaryDataSetSelector().setTimeRange(dom.getTimeRange());
        String val = dataSetSelector.getValue();
        if (val.startsWith("vap+internal:")) {
            GuiSupport.setAddPlotElementUris(applicationModel, dom, dia, val);
        } else {
            dia.getPrimaryDataSetSelector().setValue(val);
            dia.getSecondaryDataSetSelector().setValue(val);
            dia.getTertiaryDataSetSelector().setValue(val);
            dia.getPrimaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
            dia.getSecondaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
            dia.getTertiaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
        }
        if (title == null) {
            title = "Adding Plot Element";
        }
        dia.setTitle(title);
        WindowManager.getInstance().showModalDialog((Dialog)dia);
        if (dia.isCancelled()) {
            return;
        }
        GuiSupport.handleAddElementDialog(dia, dom, applicationModel);
    }

    void addPlotElementFromBookmark(String title, String furi) {
        DatumRange dr;
        DataSourceFactory factory = null;
        try {
            factory = DataSetURI.getDataSourceFactory((URI)DataSetURI.getURI((String)furi), (ProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException | IllegalArgumentException | URISyntaxException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        assert (factory != null);
        TimeSeriesBrowse tsb = (TimeSeriesBrowse)factory.getCapability(TimeSeriesBrowse.class);
        DatumRange uriRange = null;
        if (tsb != null) {
            try {
                tsb.setURI(furi);
                uriRange = tsb.getTimeRange();
            }
            catch (ParseException ex) {
                Logger.getLogger(AutoplotUI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Application dom = this.parent.getDom();
        String uri = furi;
        if (dom.getTimeRange() != Application.DEFAULT_TIME_RANGE && !dom.getTimeRange().equals((Object)uriRange) && (dr = DataSetSelector.pickTimeRange((Component)this.parent, Arrays.asList(dom.getTimeRange(), uriRange), Arrays.asList("Current", "URI"))) != uriRange) {
            try {
                uri = DataSourceUtil.setTimeRange((String)uri, (DatumRange)dom.getTimeRange(), (ProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException | URISyntaxException | ParseException ex) {
                Logger.getLogger(AutoplotUI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        ApplicationModel applicationModel = this.parent.applicationModel;
        AddPlotElementDialog dia = new AddPlotElementDialog((Frame)this.parent, true);
        dia.getPrimaryDataSetSelector().setTimeRange(dom.getTimeRange());
        dia.getSecondaryDataSetSelector().setTimeRange(dom.getTimeRange());
        dia.getTertiaryDataSetSelector().setTimeRange(dom.getTimeRange());
        String val = uri;
        if (val.startsWith("vap+internal:")) {
            GuiSupport.setAddPlotElementUris(applicationModel, dom, dia, val);
        } else {
            dia.getPrimaryDataSetSelector().setValue(val);
            dia.getSecondaryDataSetSelector().setValue(val);
            dia.getTertiaryDataSetSelector().setValue(val);
            dia.getPrimaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
            dia.getSecondaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
            dia.getTertiaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
        }
        if (title == null) {
            title = "Adding Plot Element";
        }
        dia.setTitle(title);
        WindowManager.getInstance().showModalDialog((Dialog)dia);
        if (dia.isCancelled()) {
            return;
        }
        GuiSupport.handleAddElementDialog(dia, dom, applicationModel);
    }

    private void doDumpData(QDataSet fds, DataSourceFilter dsf, PlotElement pe, DataSourceFormat format, String uriOut, String dscontrol) throws IOException {
        logger.log(Level.FINE, "exporting data to {0} using format {1}", new Object[]{uriOut, format});
        DasProgressPanel mon = null;
        try {
            QDataSet ds = fds;
            if (dsf.getController().getTsb() != null) {
                DataSource dss = dsf.getController().getDataSource();
                if (dss == null) {
                    logger.fine("looks like a TSB is used, but the data is not a time series, don't reload");
                } else {
                    dsf.getController().getTsb().setTimeResolution(null);
                    mon = DasProgressPanel.createFramed((Window)this.parent, (String)"reloading data at native resolution");
                    ds = dss.getDataSet((ProgressMonitor)mon);
                    if (mon.isCancelled()) {
                        this.parent.setStatus("export data cancelled");
                        return;
                    }
                    if (!mon.isFinished()) {
                        mon.finished();
                    }
                }
            }
            mon = DasProgressPanel.createFramed((Window)this.parent, (String)"formatting data");
            switch (dscontrol) {
                case "plotElementTrim": {
                    DasPlot p = pe.getController().getDasPlot();
                    DatumRange xbounds = p.getXAxis().getDatumRange();
                    QDataSet dsout = pe.getController().getDataSet();
                    long t0 = System.currentTimeMillis();
                    if (SemanticOps.isRank2Waveform((QDataSet)dsout)) {
                        dsout = DataSetOps.flattenWaveform((QDataSet)dsout);
                    }
                    dsout = SemanticOps.trim((QDataSet)dsout, (DatumRange)xbounds, null);
                    format.formatData(uriOut, dsout, (ProgressMonitor)mon);
                    logger.log(Level.FINE, "format in {0} millis", System.currentTimeMillis() - t0);
                    break;
                }
                case "plotElement": {
                    long t0 = System.currentTimeMillis();
                    QDataSet dsout = pe.getController().getDataSet();
                    format.formatData(uriOut, dsout, (ProgressMonitor)mon);
                    logger.log(Level.FINE, "format in {0} millis", System.currentTimeMillis() - t0);
                    break;
                }
                default: {
                    long t0 = System.currentTimeMillis();
                    format.formatData(uriOut, ds, (ProgressMonitor)mon);
                    logger.log(Level.FINE, "format in {0} millis", System.currentTimeMillis() - t0);
                    break;
                }
            }
            this.parent.setStatus("Wrote " + DataSourceUtil.unescape((String)uriOut));
        }
        catch (IllegalArgumentException ex) {
            this.parent.applicationModel.getExceptionHandler().handle((Throwable)ex);
            logger.log(Level.FINE, " ..caused exception: {0} using format {1}", new Object[]{uriOut, format});
            logger.log(Level.SEVERE, "exception " + uriOut, ex);
        }
        catch (RuntimeException ex) {
            this.parent.applicationModel.getExceptionHandler().handleUncaught((Throwable)ex);
            logger.log(Level.FINE, " ..caused exception: {0} using format {1}", new Object[]{uriOut, format});
            logger.log(Level.SEVERE, "exception " + uriOut, ex);
        }
        catch (Exception ex) {
            this.parent.applicationModel.getExceptionHandler().handle((Throwable)ex);
            logger.log(Level.FINE, " ..caused exception: {0} using format {1}", new Object[]{uriOut, format});
            logger.log(Level.SEVERE, "exception " + uriOut, ex);
        }
        if (mon != null && !mon.isFinished()) {
            mon.finished();
        }
    }

    Action getDumpDataAction(final Application dom) {
        return new AbstractAction("Export Data..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                if (dom.getController().getPlotElement() == null) {
                    JOptionPane.showMessageDialog(GuiSupport.this.parent, "Click on the plot to focus on a dataset to export.");
                    return;
                }
                ExportDataPanel edp = new ExportDataPanel();
                edp.setDataSet(dom);
                final PlotElement pe = dom.getController().getPlotElement();
                final DataSourceFilter dsf = dom.getController().getDataSourceFilterFor(pe);
                QDataSet ds = dsf.getController().getDataSet();
                if (ds == null) {
                    JOptionPane.showMessageDialog(GuiSupport.this.parent, "No Data to Export.");
                    return;
                }
                List exts = DataSourceRegistry.getInstance().getFormatterExtensions();
                Collections.sort(exts);
                edp.getFormatDL().setModel(new DefaultComboBoxModel<Object>(exts.toArray()));
                edp.getFormatDL().setRenderer(new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        String ext = String.valueOf(value);
                        DataSourceFormat format = DataSourceRegistry.getInstance().getFormatByExt(ext);
                        Component parent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                        if (parent instanceof JLabel && format != null) {
                            ((JLabel)parent).setText(value.toString() + " " + format.getDescription());
                        }
                        return parent;
                    }
                });
                Preferences prefs = AutoplotSettings.settings().getPreferences(AutoplotUI.class);
                String currentFileString = prefs.get("ExportDataCurrentFile", "");
                String currentExtString = prefs.get("ExportDataCurrentExt", ".txt");
                if (!currentExtString.equals("")) {
                    edp.getFormatDL().setSelectedItem(currentExtString);
                }
                if (!currentFileString.equals("")) {
                    URISplit split = URISplit.parse((String)currentFileString);
                    edp.getFilenameTF().setText(split.file);
                    edp.getFormatDL().setSelectedItem("." + split.ext);
                    if (currentFileString.contains("/") && (currentFileString.startsWith("file:") || currentFileString.startsWith("/"))) {
                        edp.setFile(currentFileString);
                        if (split.params != null && edp.getDataSourceFormatEditorPanel() != null) {
                            edp.getDataSourceFormatEditorPanel().setURI(currentFileString);
                        }
                    }
                }
                if (dsf.getController().getTsb() != null) {
                    edp.setTsb(true);
                }
                if (AutoplotUtil.showConfirmDialog2(GuiSupport.this.parent, edp, "Export Data", 2) == 0) {
                    try {
                        String formatControl;
                        String file;
                        String name = edp.getFilenameTF().getText();
                        if (name.startsWith(" ") || name.startsWith("\\t")) {
                            AutoplotUtil.showMessageDialog(GuiSupport.this.parent, "<html>The file name cannot start with space or tab<br>\"" + name + "\"", "Bad filename", 2);
                            return;
                        }
                        String ext = edp.getExtension();
                        try {
                            file = edp.getFilename();
                        }
                        catch (IllegalArgumentException ex) {
                            JOptionPane.showMessageDialog(GuiSupport.this.parent, ex.getMessage());
                            return;
                        }
                        if (ext == null) {
                            ext = "";
                        }
                        URISplit split = URISplit.parse((String)file);
                        DataSourceFormat format = DataSourceRegistry.getInstance().getFormatByExt(ext);
                        if (format == null) {
                            JOptionPane.showMessageDialog(GuiSupport.this.parent, "No formatter for extension: " + ext);
                            return;
                        }
                        String s = URISplit.format((URISplit)split);
                        final DataSourceFormat formata = DataSetURI.getDataSourceFormat((URI)new URI(s));
                        DataSourceFormatEditorPanel opts = edp.getDataSourceFormatEditorPanel();
                        if (opts != null) {
                            URISplit splitopts = URISplit.parse((String)opts.getURI());
                            if (splitopts.params != null && splitopts.params.length() == 0) {
                                splitopts.params = null;
                            }
                            URISplit splits = URISplit.parse((String)s);
                            splitopts.file = splits.file;
                            s = URISplit.format((URISplit)splitopts);
                            name = DataSourceUtil.unescape((String)s);
                        }
                        prefs.put("ExportDataCurrentFile", name);
                        prefs.put("ExportDataCurrentExt", ext);
                        final QDataSet fds = ds;
                        final String uriOut = s;
                        if (edp.isFormatPlotElement()) {
                            formatControl = "plotElement";
                        } else if (edp.isFormatPlotElementAndTrim()) {
                            formatControl = "plotElementTrim";
                        } else if (edp.isOriginalData()) {
                            formatControl = "dataSourceFilter";
                        } else {
                            JOptionPane.showMessageDialog(GuiSupport.this.parent, "Selected data cannot be exported to this format " + ext);
                            return;
                        }
                        Runnable run = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    GuiSupport.this.doDumpData(fds, dsf, pe, formata, uriOut, formatControl);
                                }
                                catch (IOException ex) {
                                    GuiSupport.this.parent.applicationModel.getExceptionHandler().handle((Throwable)ex);
                                }
                            }
                        };
                        new Thread(run).start();
                    }
                    catch (HeadlessException | IllegalArgumentException | URISyntaxException ex) {
                        GuiSupport.this.parent.applicationModel.getExceptionHandler().handle((Throwable)ex);
                    }
                    catch (RuntimeException ex) {
                        GuiSupport.this.parent.applicationModel.getExceptionHandler().handleUncaught((Throwable)ex);
                    }
                }
            }
        };
    }

    Action getDumpAllDataAction(final Application dom) {
        return new AbstractAction("Export All Data..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                ExportDataBundle edw = new ExportDataBundle();
                ArrayList<String> uris = new ArrayList<String>();
                for (DataSourceFilter dsf : dom.getDataSourceFilters()) {
                    uris.add(dsf.getUri());
                }
                edw.setUris(uris.toArray(new String[uris.size()]));
                if (AutoplotUtil.showConfirmDialog(GuiSupport.this.parent, edw, "Export All", 2) == 0) {
                    try {
                        ScriptContext.formatDataSet(edw.getDataSet(), edw.getUri());
                        GuiSupport.this.parent.setStatus("Wrote " + DataSourceUtil.unescape((String)edw.getUri()));
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
            }
        };
    }

    public Action createNewDOMAction() {
        return new AbstractAction("Reset Window..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg;
                int result;
                LoggerManager.logGuiEvent((ActionEvent)e);
                if (GuiSupport.this.parent.stateSupport.isDirty() && ((result = JOptionPane.showConfirmDialog(GuiSupport.this.parent, msg = "The application has been modified.  Do you want to save your changes?", "Application Modified", 1, -1)) == 0 ? (result = PersistentStateSupport.shouldUseNativeFileDialog(e) ? GuiSupport.this.parent.stateSupport.saveAsNative() : GuiSupport.this.parent.stateSupport.saveAs()) == 1 : result == 2 || result == -1)) {
                    return;
                }
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        GuiSupport.this.parent.resizeForCanvasSize(GuiSupport.this.parent.dom.getOptions().getWidth(), GuiSupport.this.parent.dom.getOptions().getHeight());
                        GuiSupport.this.parent.dom.getController().reset();
                        GuiSupport.this.parent.undoRedoSupport.resetHistory();
                        GuiSupport.this.parent.applicationModel.setVapFile(null);
                        GuiSupport.this.parent.stateSupport.close();
                        GuiSupport.this.parent.tickleTimer.tickle("resetWindow801");
                        if (GuiSupport.this.parent.isExpertMode()) {
                            GuiSupport.this.parent.setEditorCard("dataCard");
                        }
                        Runnable run2 = new Runnable(){

                            @Override
                            public void run() {
                                GuiSupport.this.parent.resizeForDefaultCanvasSize();
                            }
                        };
                        SwingUtilities.invokeLater(run2);
                    }
                };
                new Thread(run).start();
            }
        };
    }

    ApplicationModel newApplication() {
        final ApplicationModel model = new ApplicationModel();
        model.setExceptionHandler(this.parent.applicationModel.getExceptionHandler());
        Runnable run = new Runnable(){

            @Override
            public void run() {
                model.addDasPeersToApp();
                model.dom.getOptions().setDataVisible(GuiSupport.this.parent.applicationModel.dom.getOptions().isDataVisible());
                model.dom.getOptions().setLayoutVisible(GuiSupport.this.parent.applicationModel.dom.getOptions().isLayoutVisible());
                AutoplotUI view = new AutoplotUI(model);
                view.setLocationRelativeTo(GuiSupport.this.parent);
                Point p = view.getLocation();
                p.translate(20, 20);
                view.setLocation(p);
                view.setVisible(true);
                view.setMessage("ready");
                AutoplotUI.checkStatusLoop(view);
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                SwingUtilities.invokeAndWait(run);
            }
        }
        catch (InterruptedException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return model;
    }

    ApplicationModel cloneApplication() {
        final ApplicationModel model = new ApplicationModel();
        model.setExceptionHandler(this.parent.applicationModel.getExceptionHandler());
        Runnable run = new Runnable(){

            @Override
            public void run() {
                model.addDasPeersToApp();
                model.dom.getOptions().setDataVisible(GuiSupport.this.parent.applicationModel.dom.getOptions().isDataVisible());
                model.dom.getOptions().setLayoutVisible(GuiSupport.this.parent.applicationModel.dom.getOptions().isLayoutVisible());
                AutoplotUI view = new AutoplotUI(model);
                view.setLocationRelativeTo(GuiSupport.this.parent);
                view.setDefaultCloseOperation(2);
                Point p = view.getLocation();
                p.translate(20, 20);
                view.setLocation(p);
                view.setVisible(true);
                view.setMessage("ready");
                AutoplotUI.checkStatusLoop(view);
                Canvas size = GuiSupport.this.parent.applicationModel.dom.getCanvases(0);
                int extraWidth = GuiSupport.this.parent.getWindowExtraWidth();
                int extraHeight = GuiSupport.this.parent.getWindowExtraHeight();
                view.resizeForCanvasSize(size.getWidth(), size.getHeight(), extraWidth, extraHeight);
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                SwingUtilities.invokeAndWait(run);
            }
        }
        catch (InterruptedException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        model.dom.syncTo(this.parent.applicationModel.dom);
        DomUtil.copyOverInternalData(this.parent.applicationModel.dom, model.dom);
        return model;
    }

    public Action createNewApplicationAction() {
        return new AbstractAction("New Window"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                GuiSupport.this.newApplication();
            }
        };
    }

    public Action createCloneApplicationAction() {
        return new AbstractAction("Duplicate in New Window"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                GuiSupport.this.cloneApplication();
            }
        };
    }

    private static Map<String, RenderType> getRenderTypeForString() {
        LinkedHashMap<String, RenderType> tt = new LinkedHashMap<String, RenderType>();
        tt.put("Scatter", RenderType.scatter);
        tt.put("Color Scatter", RenderType.colorScatter);
        tt.put("Series", RenderType.series);
        tt.put("Stair Steps", RenderType.stairSteps);
        tt.put("Fill To Zero", RenderType.fillToZero);
        tt.put("Huge Scatter", RenderType.hugeScatter);
        tt.put("Spectrogram", RenderType.spectrogram);
        tt.put("Nearest Neighbor Spectrogram", RenderType.nnSpectrogram);
        tt.put("Digital", RenderType.digital);
        tt.put("Events Bar", RenderType.eventsBar);
        tt.put("Image", RenderType.image);
        tt.put("Pitch Angle Distribution", RenderType.pitchAngleDistribution);
        tt.put("Orbit Plot", RenderType.orbitPlot);
        tt.put("Bounds", RenderType.bounds);
        tt.put("Contour Plot", RenderType.contour);
        tt.put("Stacked Histogram", RenderType.stackedHistogram);
        return tt;
    }

    public static JMenu createEZAccessMenu(final Plot plot) {
        JMenu result = new JMenu("Plot Element Type");
        result.setToolTipText("Plot Element Type was formerly the Plot Style menu");
        result.setName(plot.getId() + "_ezaccessmenu");
        Map<String, RenderType> tt = GuiSupport.getRenderTypeForString();
        Iterator<Map.Entry<String, RenderType>> iterator = tt.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, RenderType> ee;
            final Map.Entry<String, RenderType> fee = ee = iterator.next();
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(new AbstractAction(fee.getKey()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    PlotElement pe = plot.getController().getApplication().getController().getPlotElement();
                    pe.setRenderType((RenderType)((Object)fee.getValue()));
                }
            });
            result.add(mi);
        }
        return result;
    }

    protected void addKeyBindings(JPanel thisPanel) {
        thisPanel.getActionMap().put("UNDO", this.parent.undoRedoSupport.getUndoAction());
        thisPanel.getActionMap().put("REDO", this.parent.undoRedoSupport.getRedoAction());
        thisPanel.getActionMap().put("RESET_ZOOM", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                GuiSupport.this.parent.applicationModel.resetZoom();
            }
        });
        thisPanel.getActionMap().put("INCREASE_FONT_SIZE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                GuiSupport.this.parent.applicationModel.increaseFontSize();
            }
        });
        thisPanel.getActionMap().put("DECREASE_FONT_SIZE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                GuiSupport.this.parent.applicationModel.decreaseFontSize();
            }
        });
        thisPanel.getActionMap().put("NEXT_PLOT_ELEMENT", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                Application dom = GuiSupport.this.parent.dom;
                PlotElement p = dom.getController().getPlotElement();
                int idx = Arrays.asList(dom.getPlotElements()).indexOf(p);
                if (idx == -1) {
                    idx = 0;
                }
                if (++idx == dom.getPlotElements().length) {
                    idx = 0;
                }
                dom.getController().setPlotElement(dom.getPlotElements(idx));
            }
        });
        thisPanel.getActionMap().put("PREV_PLOT_ELEMENT", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                Application dom = GuiSupport.this.parent.dom;
                PlotElement p = dom.getController().getPlotElement();
                int idx = Arrays.asList(dom.getPlotElements()).indexOf(p);
                if (idx == -1) {
                    idx = 0;
                }
                if (--idx == -1) {
                    idx = dom.getPlotElements().length - 1;
                }
                dom.getController().setPlotElement(dom.getPlotElements(idx));
            }
        });
        thisPanel.getActionMap().put("SAVE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                GuiSupport.this.parent.stateSupport.createSaveAction().actionPerformed(e);
            }
        });
        thisPanel.getActionMap().put("RELOAD_ALL", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                RequestProcessor.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AutoplotUtil.reloadAll(GuiSupport.this.parent.dom);
                    }
                });
            }
        });
        ComponentInputMap map = new ComponentInputMap(thisPanel);
        Toolkit tk = Toolkit.getDefaultToolkit();
        ((InputMap)map).put(KeyStroke.getKeyStroke(90, tk.getMenuShortcutKeyMask()), "UNDO");
        ((InputMap)map).put(KeyStroke.getKeyStroke(89, tk.getMenuShortcutKeyMask()), "REDO");
        ((InputMap)map).put(KeyStroke.getKeyStroke(82, tk.getMenuShortcutKeyMask()), "RESET_ZOOM");
        ((InputMap)map).put(KeyStroke.getKeyStroke(45, tk.getMenuShortcutKeyMask()), "DECREASE_FONT_SIZE");
        ((InputMap)map).put(KeyStroke.getKeyStroke(521, tk.getMenuShortcutKeyMask()), "INCREASE_FONT_SIZE");
        ((InputMap)map).put(KeyStroke.getKeyStroke(61, tk.getMenuShortcutKeyMask()), "INCREASE_FONT_SIZE");
        ((InputMap)map).put(KeyStroke.getKeyStroke(61, 0x40 | tk.getMenuShortcutKeyMask()), "INCREASE_FONT_SIZE");
        ((InputMap)map).put(KeyStroke.getKeyStroke(9, 128), "NEXT_PLOT_ELEMENT");
        ((InputMap)map).put(KeyStroke.getKeyStroke(9, 192), "PREV_PLOT_ELEMENT");
        ((InputMap)map).put(KeyStroke.getKeyStroke(83, tk.getMenuShortcutKeyMask()), "SAVE");
        ((InputMap)map).put(KeyStroke.getKeyStroke(76, tk.getMenuShortcutKeyMask()), "RELOAD_ALL");
        thisPanel.setInputMap(2, map);
    }

    protected void exportRecent(Component c) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileNameExtensionFilter("bookmarks files", "xml"));
        int r = chooser.showSaveDialog(c);
        if (r == 0) {
            try {
                File f = chooser.getSelectedFile();
                if (!f.toString().endsWith(".xml")) {
                    f = new File(f.toString() + ".xml");
                }
                try (FileOutputStream out = new FileOutputStream(f);){
                    Bookmark.formatBooks(out, this.parent.applicationModel.getRecent());
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public static FileFilter getFileNameExtensionFilter(final String description, final String ext) {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                String s = f.getName();
                return f.isDirectory() || s.endsWith(ext);
            }

            @Override
            public String getDescription() {
                return description;
            }
        };
    }

    public static Action getPrintAction(final Application app, final Component parent, final String ext) {
        return new AbstractAction("Print as " + ext.toUpperCase()){

            @Override
            public void actionPerformed(ActionEvent e) {
                PdfOptionsPanel decor;
                LoggerManager.logGuiEvent((ActionEvent)e);
                final DasCanvas canvas = app.getController().getDasCanvas();
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setDialogTitle("Print to " + ext.toUpperCase());
                fileChooser.setFileFilter(new FileNameExtensionFilter(ext + " files", ext));
                Preferences prefs = AutoplotSettings.settings().getPreferences(DasCanvas.class);
                String savedir = prefs.get("savedir", null);
                if (savedir != null) {
                    fileChooser.setCurrentDirectory(new File(savedir));
                }
                if (currentFile != null) {
                    if (currentFile.toString().endsWith("." + ext)) {
                        fileChooser.setSelectedFile(currentFile);
                    } else {
                        fileChooser.setSelectedFile(new File(currentFile.toString() + "." + ext));
                    }
                }
                if (ext.equals("pdf")) {
                    decor = new PdfOptionsPanel();
                    fileChooser.setAccessory(decor);
                } else {
                    decor = null;
                }
                int choice = fileChooser.showSaveDialog(parent);
                if (choice == 0) {
                    String fname = fileChooser.getSelectedFile().toString();
                    if (!fname.toLowerCase().endsWith("." + ext)) {
                        fname = fname + "." + ext;
                    }
                    final String ffname = fname;
                    prefs.put("savedir", new File(ffname).getParent());
                    currentFile = new File(ffname.substring(0, ffname.length() - 4));
                    Runnable run = new Runnable(){

                        /*
                         * Unable to fully structure code
                         */
                        @Override
                        public void run() {
                            try {
                                var1_1 = ext;
                                var2_3 = -1;
                                switch (var1_1.hashCode()) {
                                    case 111145: {
                                        if (!var1_1.equals("png")) break;
                                        var2_3 = 0;
                                        break;
                                    }
                                    case 110834: {
                                        if (!var1_1.equals("pdf")) break;
                                        var2_3 = 1;
                                        break;
                                    }
                                    case 114276: {
                                        if (!var1_1.equals("svg")) break;
                                        var2_3 = 2;
                                    }
                                }
                                switch (var2_3) {
                                    case 0: {
                                        canvas.writeToPng(ffname);
                                        break;
                                    }
                                    case 1: {
                                        out = new FileOutputStream(ffname);
                                        var4_5 = null;
                                        go = new PdfGraphicsOutput();
                                        pdecor = (PdfOptionsPanel)decor;
                                        go.setGraphicsShapes(pdecor.fontsAsShapesCB.isSelected());
                                        go.setOutputStream((OutputStream)out);
                                        if (pdecor.manualWidthCB.isSelected()) {
                                            mant = Double.parseDouble(pdecor.widthTF.getText());
                                            var10_13 = units = (String)pdecor.unitsComboBox.getSelectedItem();
                                            var11_15 = -1;
                                            switch (var10_13.hashCode()) {
                                                case -1184266632: {
                                                    if (!var10_13.equals("inches")) break;
                                                    var11_15 = 0;
                                                    break;
                                                }
                                                case 789503243: {
                                                    if (!var10_13.equals("centimeters")) break;
                                                    var11_15 = 1;
                                                }
                                            }
                                            switch (var11_15) {
                                                case 0: {
                                                    mant *= 72.0;
                                                    break;
                                                }
                                                case 1: {
                                                    mant = mant * 72.0 / 2.54;
                                                    break;
                                                }
                                                default: {
                                                    throw new IllegalArgumentException("implementation error: " + units);
                                                }
                                            }
                                            ppi = (int)((double)(canvas.getWidth() * 72) / mant);
                                            go.setPixelsPerInch(ppi);
                                            go.setSize(canvas.getWidth(), canvas.getHeight());
                                        } else if (pdecor.getPixelsPerInch().length() > 0) {
                                            ppi = Integer.parseInt(pdecor.getPixelsPerInch());
                                            go.setPixelsPerInch(ppi);
                                            go.setSize(canvas.getWidth(), canvas.getHeight());
                                        } else {
                                            go.setSize(canvas.getWidth(), canvas.getHeight());
                                        }
                                        go.start();
                                        canvas.print(go.getGraphics());
                                        go.finish();
                                        if (out == null) break;
                                        if (var4_5 == null) ** GOTO lbl70
                                        try {
                                            out.close();
                                        }
                                        catch (Throwable var5_7) {
                                            var4_5.addSuppressed(var5_7);
                                        }
                                        break;
lbl70:
                                        // 1 sources

                                        out.close();
                                        break;
                                        catch (Throwable var5_8) {
                                            try {
                                                var4_5 = var5_8;
                                                throw var5_8;
                                            }
                                            catch (Throwable var12_16) {
                                                if (out != null) {
                                                    if (var4_5 != null) {
                                                        try {
                                                            out.close();
                                                        }
                                                        catch (Throwable var13_17) {
                                                            var4_5.addSuppressed(var13_17);
                                                        }
                                                    } else {
                                                        out.close();
                                                    }
                                                }
                                                throw var12_16;
                                            }
                                        }
                                    }
                                    case 2: {
                                        canvas.writeToSVG(ffname);
                                        break;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("implementation error: " + ext);
                                    }
                                }
                                app.getController().setStatus("wrote to " + ffname);
                            }
                            catch (IOException ioe) {
                                DasApplication.getDefaultApplication().getExceptionHandler().handle((Throwable)ioe);
                            }
                        }
                    };
                    new Thread(run, "writePrint").start();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mergeVap(Application dom, Plot plot, PlotElement pelement, String vap) {
        block7: {
            try {
                ImportVapDialog d = new ImportVapDialog();
                if (vap.contains("?")) {
                    int i = vap.indexOf(63);
                    vap = vap.substring(0, i);
                }
                d.setVap(vap);
                if (d.showDialog(SwingUtilities.getWindowAncestor((Component)dom.getController().getDasCanvas())) != 0) break block7;
                String lock = "merging vaps";
                dom.getController().registerPendingChange(d, lock);
                try {
                    dom.getController().performingChange(d, lock);
                    List<String> uris = d.getSelectedURIs();
                    for (String uri : uris) {
                        dom.getController().doplot(plot, pelement, uri);
                        pelement = null;
                    }
                }
                finally {
                    dom.getController().changePerformed(d, lock);
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importBookmarks(String bookmarksFile) {
        ImportBookmarksGui gui = new ImportBookmarksGui();
        gui.getBookmarksFilename().setText(bookmarksFile + " ?");
        gui.getRemote().setSelected(true);
        int r = WindowManager.showConfirmDialog((Component)this.parent, (Object)gui, (String)"Import bookmarks file", (int)2);
        if (r == 0) {
            InputStream in = null;
            try {
                DasProgressPanel mon = DasProgressPanel.createFramed((String)"importing bookmarks");
                if (gui.getRemote().isSelected()) {
                    this.parent.getBookmarksManager().getModel().addRemoteBookmarks(bookmarksFile);
                    this.parent.getBookmarksManager().reload();
                } else {
                    in = DataSetURI.getInputStream((URI)DataSetURI.getURIValid((String)bookmarksFile), (ProgressMonitor)mon);
                    ByteArrayOutputStream boas = new ByteArrayOutputStream();
                    WritableByteChannel dest = Channels.newChannel(boas);
                    ReadableByteChannel src = Channels.newChannel(in);
                    DataSourceUtil.transfer((ReadableByteChannel)src, (WritableByteChannel)dest);
                    String sin = new String(boas.toByteArray());
                    List<Bookmark> books = Bookmark.parseBookmarks(sin);
                    this.parent.getBookmarksManager().getModel().importList(books);
                }
                this.parent.setMessage("imported bookmarks file " + bookmarksFile);
            }
            catch (BookmarksException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                this.parent.applicationModel.showMessage("Semantic Error parsing " + bookmarksFile + "\n" + ex.getMessage(), "Error in import bookmarks", 2);
            }
            catch (SAXException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                this.parent.applicationModel.showMessage("XML Error parsing " + bookmarksFile + "\n" + ex.getMessage(), "Error in import bookmarks", 2);
            }
            catch (URISyntaxException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            catch (FileNotFoundException ex) {
                this.parent.applicationModel.showMessage("File not found: " + bookmarksFile, "Error in import bookmarks", 2);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                this.parent.applicationModel.showMessage("I/O Error with " + bookmarksFile, "Error in import bookmarks", 2);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleAddElementDialog(final AddPlotElementDialog dia, final Application dom, final ApplicationModel applicationModel) {
        String[] filters;
        String[] uris;
        Plot plot = null;
        PlotElement pelement = null;
        int modifiers = dia.getModifiers();
        if ((modifiers & 2) == 2 && (modifiers & 1) == 1) {
            plot = dom.getController().addPlot(LayoutConstants.ABOVE);
            pelement = null;
        } else if ((modifiers & 2) == 2) {
            plot = null;
            pelement = null;
        } else if ((modifiers & 1) == 1) {
            plot = dom.getController().getPlot();
        } else {
            pelement = dom.getController().getPlotElement();
        }
        final Plot lplot = plot;
        final PlotElement lpelement = pelement;
        switch (dia.getDepCount()) {
            case 0: {
                uris = new String[]{dia.getPrimaryDataSetSelector().getValue()};
                filters = new String[]{dia.getPrimaryFilters()};
                break;
            }
            case 1: {
                uris = new String[]{dia.getSecondaryDataSetSelector().getValue(), dia.getPrimaryDataSetSelector().getValue()};
                filters = new String[]{dia.getSecondaryFilters(), dia.getPrimaryFilters()};
                break;
            }
            case 2: {
                uris = new String[]{dia.getSecondaryDataSetSelector().getValue(), dia.getTertiaryDataSetSelector().getValue(), dia.getPrimaryDataSetSelector().getValue()};
                filters = new String[]{dia.getSecondaryFilters(), dia.getTertiaryFilters(), dia.getPrimaryFilters()};
                break;
            }
            default: {
                throw new IllegalArgumentException("this can't happen");
            }
        }
        int depCount = dia.getDepCount();
        String lock = "plotWithSlice";
        dom.getController().registerPendingChange(dom, "plotWithSlice");
        try {
            switch (depCount) {
                case 0: {
                    applicationModel.addRecent(uris[0]);
                    String val = uris[0];
                    if (val.endsWith(".vap")) {
                        try {
                            GuiSupport.mergeVap(dom, lplot, lpelement, val);
                            break;
                        }
                        finally {
                            dom.getController().changePerformed(dom, "plotWithSlice");
                        }
                    }
                    final String lval = val;
                    Runnable run = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                String uri = lval;
                                DataSourceFactory factory = DataSetURI.getDataSourceFactory((URI)DataSetURI.getURI((String)uri), (ProgressMonitor)new NullProgressMonitor());
                                if (factory == null) {
                                    if (uri.startsWith("vap+internal:")) {
                                        DataSourceFilter dsf = dom.getController().addDataSourceFilter();
                                        dsf.setUri(uri);
                                        dom.getController().addPlotElement(lplot, dsf);
                                        return;
                                    }
                                    throw new IllegalArgumentException("unable to resolve URI: " + uri);
                                }
                                ArrayList problems = new ArrayList();
                                while (factory.reject(uri, problems, (ProgressMonitor)new NullProgressMonitor())) {
                                    String val;
                                    dia.setTitle("Add Plot, URI was rejected...");
                                    dia.setMessagesLabelText("The URI was rejected.  Verify that it is correct using the inspect button (right).");
                                    WindowManager.getInstance().showModalDialog((Dialog)dia);
                                    if (dia.isCancelled()) {
                                        return;
                                    }
                                    uri = val = dia.getPrimaryDataSetSelector().getValue();
                                }
                                PlotElement pelement = dom.getController().doplot(lplot, lpelement, lval);
                                DataSourceFilter dsf = (DataSourceFilter)DomUtil.getElementById(dom, pelement.getDataSourceFilterId());
                                if (dia.getPrimaryFilters().length() > 0) {
                                    dsf.setFilters(dia.getPrimaryFilters());
                                }
                            }
                            catch (IOException | URISyntaxException ex) {
                                applicationModel.showMessage(ex.getMessage(), "Illegal Argument", 0);
                            }
                            finally {
                                dom.getController().changePerformed(dom, "plotWithSlice");
                            }
                        }
                    };
                    run.run();
                    break;
                }
                case 1: {
                    applicationModel.addRecent(uris[0]);
                    applicationModel.addRecent(uris[1]);
                    Runnable run = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                dom.getController().performingChange(dom, "plotWithSlice");
                                PlotElement pele = dom.getController().doplot(lplot, lpelement, uris[0], uris[1]);
                                DataSourceFilter dsf = (DataSourceFilter)DomUtil.getElementById(dom, pele.getDataSourceFilterId());
                                List<DataSourceFilter> dsfs = DomUtil.getParentsFor(dom, dsf.getUri());
                                if (dsfs.size() == 2 && dsfs.get(0) != null && dsfs.get(1) != null) {
                                    if (filters[0].length() > 0) {
                                        dsfs.get(0).setFilters(filters[0]);
                                    }
                                    if (filters[1].length() > 0) {
                                        dsfs.get(1).setFilters(filters[1]);
                                    }
                                }
                                dom.getController().setFocusUri(dom.getController().getDataSourceFilterFor(pele).getUri());
                            }
                            finally {
                                dom.getController().changePerformed(dom, "plotWithSlice");
                            }
                        }
                    };
                    new Thread(run).start();
                    break;
                }
                case 2: {
                    applicationModel.addRecent(uris[0]);
                    applicationModel.addRecent(uris[1]);
                    applicationModel.addRecent(uris[2]);
                    Runnable run = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                dom.getController().performingChange(dom, "plotWithSlice");
                                PlotElement pele = dom.getController().doplot(lplot, lpelement, uris[0], uris[1], uris[2]);
                                DataSourceFilter dsf = (DataSourceFilter)DomUtil.getElementById(dom, pele.getDataSourceFilterId());
                                List<DataSourceFilter> dsfs = DomUtil.getParentsFor(dom, dsf.getUri());
                                if (dsfs.size() == 3 && dsfs.get(0) != null && dsfs.get(1) != null && dsfs.get(2) != null) {
                                    if (filters[0].length() > 0) {
                                        dsfs.get(0).setFilters(filters[0]);
                                    }
                                    if (filters[1].length() > 0) {
                                        dsfs.get(1).setFilters(filters[1]);
                                    }
                                    if (filters[2].length() > 0) {
                                        dsfs.get(2).setFilters(filters[2]);
                                    }
                                }
                                dom.getController().setFocusUri(dom.getController().getDataSourceFilterFor(pele).getUri());
                            }
                            finally {
                                dom.getController().changePerformed(dom, "plotWithSlice");
                            }
                        }
                    };
                    new Thread(run).start();
                    break;
                }
                case -1: {
                    dom.getController().changePerformed(dom, "plotWithSlice");
                    break;
                }
                default: {
                    dom.getController().changePerformed(dom, "plotWithSlice");
                }
            }
        }
        catch (IllegalArgumentException ex) {
            applicationModel.showMessage(ex.getMessage(), "Illegal Argument", 0);
        }
    }

    private static void bindToPlotPeer(ApplicationController controller, Plot dstPlot, Plot plot, Axis axis, String[] props) throws IllegalArgumentException {
        Axis targetAxis;
        if (plot.getXaxis() == axis) {
            targetAxis = dstPlot.getXaxis();
        } else if (plot.getYaxis() == axis) {
            targetAxis = dstPlot.getYaxis();
        } else if (plot.getZaxis() == axis) {
            targetAxis = dstPlot.getZaxis();
        } else {
            throw new IllegalArgumentException("this axis and plot don't go together");
        }
        if (props == null) {
            axis.setLog(targetAxis.isLog());
            axis.setRange(targetAxis.getRange());
            props = new String[]{"log", "range"};
        }
        for (String p : props) {
            controller.bind(targetAxis, p, axis, p);
        }
    }

    protected static void addAxisContextMenuItems(final ApplicationController controller, final DasPlot dasPlot, PlotController plotController, final Plot plot, final Axis axis) {
        JMenuItem addPlotMenu;
        final DasAxis dasAxis = axis.getController().getDasAxis();
        DasMouseInputAdapter mouseAdapter = dasAxis.getDasMouseInputAdapter();
        ArrayList<JMenuItem> expertMenuItems = new ArrayList<JMenuItem>();
        mouseAdapter.removeMenuItem("Properties");
        JMenuItem item = new JMenuItem(new AbstractAction("Axis Properties"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                PropertyEditor pp = new PropertyEditor((Object)axis);
                pp.showDialog((Component)dasAxis.getCanvas());
            }
        });
        mouseAdapter.addMenuItem((Component)item);
        expertMenuItems.add(item);
        mouseAdapter.addMenuItem((Component)new JSeparator());
        item = new JMenuItem(new AbstractAction("Reset Zoom"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                if (plot.getZaxis() == axis) {
                    AutoplotUtil.resetZoomZ(controller.getApplication(), plot);
                } else if (axis == plot.getXaxis()) {
                    AutoplotUtil.resetZoomX(controller.getApplication(), plot);
                } else {
                    AutoplotUtil.resetZoomY(controller.getApplication(), plot);
                }
            }
        });
        mouseAdapter.addMenuItem((Component)item);
        if (axis == plot.getXaxis()) {
            addPlotMenu = new JMenu("Add Plot");
            mouseAdapter.addMenuItem((Component)addPlotMenu);
            item = new JMenuItem(new AbstractAction("Bound Plot Below"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    controller.copyPlot(plot, true, false, true);
                }
            });
            item.setToolTipText("add a new plot below.  The plot's x axis will be bound to this plot's x axis");
            ((JMenu)addPlotMenu).add(item);
            expertMenuItems.add(addPlotMenu);
        }
        if (axis == plot.getZaxis()) {
            addPlotMenu = new JMenuItem(new AbstractAction("Set Color Table..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    final EnumerationEditor edit = new EnumerationEditor();
                    DasColorBar.Type type0 = ((DasColorBar)dasAxis).getType();
                    edit.setValue((Object)type0);
                    edit.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            ((DasColorBar)dasAxis).setType((DasColorBar.Type)edit.getValue());
                        }
                    });
                    edit.setValue((Object)((DasColorBar)dasAxis).getType());
                    if (0 != JOptionPane.showConfirmDialog((Component)dasAxis.getCanvas(), edit.getCustomEditor(), "Set Color Table", 2)) {
                        ((DasColorBar)dasAxis).setType(type0);
                    }
                }
            });
            item.setToolTipText("reset the colorbar");
            mouseAdapter.addMenuItem((Component)addPlotMenu);
            expertMenuItems.add(addPlotMenu);
        }
        JMenu bindingMenu = new JMenu("Binding");
        mouseAdapter.addMenuItem((Component)bindingMenu);
        if (axis == plot.getXaxis()) {
            item = new JMenuItem(new AbstractAction("Add Binding to Application Time Range"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    DatumRange dr = controller.getApplication().getTimeRange();
                    if (dr == Application.DEFAULT_TIME_RANGE) {
                        controller.getApplication().setTimeRange(dr.next());
                        controller.getApplication().setTimeRange(dr.next().previous());
                    }
                    controller.bind(controller.getApplication(), "timeRange", axis, "range");
                }
            });
            bindingMenu.add(item);
        }
        item = new JMenuItem(new AbstractAction("Bind Range to Plot Above"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                Plot dstPlot = controller.getPlotAbove(plot);
                if (dstPlot == null) {
                    controller.setStatus("warning: no plot above");
                } else {
                    GuiSupport.bindToPlotPeer(controller, dstPlot, plot, axis, null);
                }
            }
        });
        bindingMenu.add(item);
        item = new JMenuItem(new AbstractAction("Bind Range to Plot Below"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                Plot dstPlot = controller.getPlotBelow(plot);
                if (dstPlot == null) {
                    controller.setStatus("warning: no plot below");
                } else {
                    GuiSupport.bindToPlotPeer(controller, dstPlot, plot, axis, null);
                }
            }
        });
        bindingMenu.add(item);
        item = new JMenuItem(new AbstractAction("Bind Range to Plot to the Right"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                Plot dstPlot = controller.getNextPlotHoriz(plot, LayoutConstants.RIGHT);
                if (dstPlot == null) {
                    controller.setStatus("warning: no plot to the right");
                } else {
                    GuiSupport.bindToPlotPeer(controller, dstPlot, plot, axis, null);
                }
            }
        });
        bindingMenu.add(item);
        item = new JMenuItem(new AbstractAction("Bind Range to Plot to the Left"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                Plot dstPlot = controller.getNextPlotHoriz(plot, LayoutConstants.LEFT);
                if (dstPlot == null) {
                    controller.setStatus("warning: no plot to the left");
                } else {
                    GuiSupport.bindToPlotPeer(controller, dstPlot, plot, axis, null);
                }
            }
        });
        bindingMenu.add(item);
        item = new JMenuItem(new AbstractAction("Bind Scale to Plot Above"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                Plot dstPlot = controller.getPlotAbove(plot);
                if (dstPlot == null) {
                    controller.setStatus("warning: no plot above");
                } else {
                    GuiSupport.bindToPlotPeer(controller, dstPlot, plot, axis, new String[]{"log", "scale"});
                }
            }
        });
        bindingMenu.add(item);
        item = new JMenuItem(new AbstractAction("Bind Scale to Plot Below"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                Plot dstPlot = controller.getPlotBelow(plot);
                if (dstPlot == null) {
                    controller.setStatus("warning: no plot below");
                } else {
                    GuiSupport.bindToPlotPeer(controller, dstPlot, plot, axis, new String[]{"log", "scale"});
                }
            }
        });
        bindingMenu.add(item);
        item = new JMenuItem(new AbstractAction("Bind Scale to Opposite Axis"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                controller.bind(plot.getXaxis(), "log", plot.getYaxis(), "log");
                controller.bind(plot.getXaxis(), "scale", plot.getYaxis(), "scale");
            }
        });
        bindingMenu.add(item);
        item = new JMenuItem(new AbstractAction("Remove Bindings"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                BindingModel[] bms = controller.getBindingsFor(axis);
                controller.unbind(axis);
                controller.setStatus("removed " + bms.length + " bindings");
            }
        });
        item.setToolTipText("remove any plot and plot element property bindings");
        bindingMenu.add(item);
        expertMenuItems.add(bindingMenu);
        JMenu connectorMenu = new JMenu("Connector");
        mouseAdapter.addMenuItem((Component)connectorMenu);
        item = new JMenuItem(new AbstractAction("Add Connector to Plot Above"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                Plot dstPlot = controller.getPlotAbove(plot);
                if (dstPlot == null) {
                    controller.setStatus("warning: no plot above");
                } else {
                    controller.addConnector(dstPlot, plot);
                }
            }
        });
        connectorMenu.add(item);
        item = new JMenuItem(new AbstractAction("Add Connector to Plot Below"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                Plot dstPlot = controller.getPlotBelow(plot);
                if (dstPlot == null) {
                    controller.setStatus("warning: no plot below");
                } else {
                    controller.addConnector(plot, dstPlot);
                }
            }
        });
        connectorMenu.add(item);
        item = new JMenuItem(new AbstractAction("Delete Connectors"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                Application dom = plot.getController().getApplication();
                for (Connector c : DomUtil.asArrayList(dom.getConnectors())) {
                    if (!c.getPlotA().equals(plot.getId()) && !c.getPlotB().equals(plot.getId())) continue;
                    dom.getController().deleteConnector(c);
                }
                dom.getController().getCanvas().getController().getDasCanvas().repaint();
            }
        });
        connectorMenu.add(item);
        expertMenuItems.add(connectorMenu);
        if (axis.getController().getDasAxis().isHorizontal()) {
            item = new JMenuItem(new AbstractAction("Add Additional Ticks from..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String nuri;
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    String uri = plot.getTicksURI();
                    if (uri.startsWith("class:org.autoplot.tca.UriTcaSource:")) {
                        uri = uri.substring("class:org.autoplot.tca.UriTcaSource:".length());
                    }
                    if (UnitsUtil.isTimeLocation((Units)axis.getController().getDasAxis().getDatumRange().getUnits()) && (nuri = DataSetURI.resetUriTsbTime((String)uri, (DatumRange)axis.getController().getDasAxis().getDatumRange())) != null && !nuri.equals(uri)) {
                        uri = nuri;
                    }
                    TcaElementDialog dia = new TcaElementDialog((Frame)((JFrame)SwingUtilities.getWindowAncestor(controller.getDasCanvas().getParent())), true);
                    dia.getPrimaryDataSetSelector().setValue(uri);
                    dia.getPrimaryDataSetSelector().setTimeRange(axis.getController().getDasAxis().getDatumRange());
                    dia.setTitle("Add additional ticks");
                    dia.setVisible(true);
                    if (dia.isCancelled()) {
                        return;
                    }
                    uri = dia.getPrimaryDataSetSelector().getValue();
                    if (uri.length() == 0) {
                        plot.setTicksURI("");
                    } else {
                        plot.setTicksURI(uri);
                    }
                }
            });
            mouseAdapter.addMenuItem((Component)item);
            expertMenuItems.add(item);
        }
        item = new JMenuItem(new AbstractAction("Reset axis units to..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                Units u = dasAxis.getUnits();
                Units[] uu = u.getConvertibleUnits();
                ArrayList<Units> uus = new ArrayList<Units>(Arrays.asList(uu));
                List<PlotElement> pes = DomUtil.getPlotElementsFor(controller.getApplication(), plot);
                for (PlotElement pe : pes) {
                    Units u1 = dasAxis.isHorizontal() ? pe.getPlotDefaults().getXaxis().getRange().getUnits() : (dasPlot.getYAxis() == dasAxis ? pe.getPlotDefaults().getYaxis().getRange().getUnits() : pe.getPlotDefaults().getZaxis().getRange().getUnits());
                    if (uus.contains(u1) || u1.equals(u) || !UnitsUtil.isIntervalOrRatioMeasurement((Units)u1)) continue;
                    uus.add(u1);
                }
                uu = uus.toArray(new Units[uus.size()]);
                JFrame p = (JFrame)SwingUtilities.getWindowAncestor(controller.getDasCanvas().getParent());
                if (uu.length < 1) {
                    JOptionPane.showMessageDialog(p, "No conversions found from \"" + u + "\"");
                } else {
                    JPanel p1 = new JPanel();
                    p1.setLayout(new BoxLayout(p1, 1));
                    p1.setAlignmentY(0.0f);
                    p1.setAlignmentX(0.0f);
                    JLabel l = new JLabel("Axis units are \"" + u + "\"");
                    l.setAlignmentX(0.0f);
                    p1.add(l);
                    l = new JLabel("Reset axis units to:");
                    l.setAlignmentX(0.0f);
                    p1.add(l);
                    JComboBox<Units> cb = new JComboBox<Units>(uu);
                    cb.setSelectedItem(u);
                    cb.setAlignmentX(0.0f);
                    p1.add(cb);
                    if (0 == WindowManager.showConfirmDialog((Component)p, (Object)p1, (String)"Reset axis units", (int)2)) {
                        Units nu = (Units)cb.getSelectedItem();
                        if (nu.isConvertibleTo(u)) {
                            axis.getController().resetAxisUnits(nu);
                        } else {
                            DatumRange oldRange = dasAxis.getDatumRange();
                            DatumRange newRange = new DatumRange(oldRange.min().value(), oldRange.max().value(), nu);
                            axis.getController().resetAxisRange(newRange);
                        }
                    }
                }
            }
        });
        mouseAdapter.addMenuItem((Component)item);
        expertMenuItems.add(item);
        ArrayList<JMenuItem> expertMenuItemsList = new ArrayList<JMenuItem>(Arrays.asList(plotController.getExpertMenuItems()));
        expertMenuItemsList.addAll(expertMenuItems);
        plotController.setExpertMenuItems(expertMenuItemsList.toArray(new JMenuItem[expertMenuItemsList.size()]));
    }

    private static boolean isStringVap(String s) {
        return s.startsWith("<?xml");
    }

    public static void pasteClipboardIntoPlot(final Component app, final ApplicationController controller, final Plot newP) throws HeadlessException {
        try {
            String thevap;
            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (clpbrd.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                thevap = (String)clpbrd.getData(DataFlavor.stringFlavor);
                if (!GuiSupport.isStringVap(thevap)) {
                    JOptionPane.showMessageDialog(app, "Use \"Edit Plot\"->\"Copy Plot to Clipboard\"<br>(Pasted content should be XML.)");
                    return;
                }
            } else {
                JOptionPane.showMessageDialog(app, "Use \"Edit Plot\"->\"Copy Plot to Clipboard\"");
                return;
            }
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        GuiSupport.insertStringVapIntoPlot(app, controller, newP, thevap);
                    }
                    catch (IllegalArgumentException ex) {
                        JOptionPane.showMessageDialog(app, "Use \"Edit Plot\"->\"Copy Plot to Clipboard\"<br>(Pasted content is not XML containing a plot.)");
                    }
                    catch (HeadlessException | IOException ex) {
                        Logger.getLogger(GuiSupport.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            };
            SwingUtilities.invokeLater(run);
        }
        catch (UnsupportedFlavorException | IOException ex) {
            Logger.getLogger(GuiSupport.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertStringVapIntoPlot(Component app, ApplicationController controller, Plot targetPlot, String theVap) throws HeadlessException, IOException, IllegalArgumentException {
        Application state = (Application)StatePersistence.restoreState(new ByteArrayInputStream(theVap.getBytes()));
        String lockObject = "pasteClipboard";
        controller.registerPendingChange(app, lockObject);
        ChangesSupport.DomLock lock = controller.mutatorLock();
        try {
            int i;
            boolean doBindX;
            Column c;
            Row r;
            Plot p;
            int i2;
            lock.lock("pasting plot");
            controller.performingChange(app, lockObject);
            List<PlotElement> pes = controller.getPlotElementsFor(targetPlot);
            pes.forEach(pe -> controller.deletePlotElement((PlotElement)pe));
            Plot srcPlot = state.getPlots(0);
            List<String> exclude = Arrays.asList("id", "drawTickLabels", "visible", "opposite");
            if (targetPlot.getXaxis().getRange().getUnits().isConvertibleTo(srcPlot.getXaxis().getRange().getUnits()) && !targetPlot.getXaxis().isAutoRange()) {
                srcPlot.getXaxis().setRange(targetPlot.getXaxis().getRange());
                srcPlot.getXaxis().setLog(targetPlot.getXaxis().isLog());
            }
            targetPlot.getXaxis().syncTo(srcPlot.getXaxis(), exclude);
            if (targetPlot.getYaxis().getRange().getUnits().isConvertibleTo(srcPlot.getYaxis().getRange().getUnits()) && !targetPlot.getYaxis().isAutoRange()) {
                srcPlot.getYaxis().setRange(targetPlot.getYaxis().getRange());
                srcPlot.getYaxis().setLog(targetPlot.getYaxis().isLog());
            }
            targetPlot.getYaxis().syncTo(srcPlot.getYaxis(), exclude);
            exclude = Arrays.asList("id", "rowId", "columnId", "ticksURI", "ephemerisLabels", "ephemerisLineCount", "xaxis", "yaxis");
            targetPlot.syncTo(srcPlot, exclude);
            targetPlot.setTicksURI("");
            targetPlot.setEphemerisLabels("");
            targetPlot.setEphemerisLineCount(-1);
            HashMap<String, String> nameMap = new HashMap<String, String>();
            nameMap.put(srcPlot.getId(), targetPlot.getId());
            nameMap.put(srcPlot.getXaxis().getId(), targetPlot.getXaxis().getId());
            nameMap.put(srcPlot.getYaxis().getId(), targetPlot.getYaxis().getId());
            nameMap.put(srcPlot.getZaxis().getId(), targetPlot.getZaxis().getId());
            for (i2 = 1; i2 < state.getPlots().length; ++i2) {
                p = state.getPlots(i2);
                if (p == srcPlot || !p.getRowId().equals(srcPlot.getRowId()) || !p.getColumnId().equals(srcPlot.getColumnId())) continue;
                r = DomUtil.getRow(controller.getApplication(), targetPlot.getRowId());
                c = DomUtil.getColumn(controller.getApplication(), targetPlot.getColumnId());
                Plot newPlot = controller.addPlot(r, c);
                exclude = Arrays.asList("id", "rowId", "columnId");
                newPlot.syncTo(state.getPlots(i2), exclude);
                nameMap.put(state.getPlots(i2).getId(), newPlot.getId());
                nameMap.put(state.getPlots(i2).getXaxis().getId(), newPlot.getXaxis().getId());
                nameMap.put(state.getPlots(i2).getYaxis().getId(), newPlot.getYaxis().getId());
                nameMap.put(state.getPlots(i2).getZaxis().getId(), newPlot.getZaxis().getId());
            }
            for (i2 = 1; i2 < state.getPlots().length; ++i2) {
                p = state.getPlots(i2);
                if (p == srcPlot) continue;
                r = DomUtil.getRow(state, p.getRowId());
                c = DomUtil.getColumn(state, p.getColumnId());
                if (!r.getParent().equals(srcPlot.getRowId()) || !c.getParent().equals(srcPlot.getColumnId())) continue;
                Row newRow = controller.getCanvas().getController().addRow();
                Column newColumn = controller.getCanvas().getController().addColumn();
                newRow.syncTo(r, Arrays.asList("id", "parent"));
                newRow.setParent(targetPlot.getRowId());
                newColumn.syncTo(c, Arrays.asList("id", "parent"));
                newColumn.setParent(targetPlot.getColumnId());
                Plot newPlot = controller.addPlot(newRow, newColumn);
                exclude = Arrays.asList("id", "rowId", "columnId");
                newPlot.syncTo(p, exclude);
                nameMap.put(p.getId(), newPlot.getId());
                nameMap.put(p.getXaxis().getId(), newPlot.getXaxis().getId());
                nameMap.put(p.getYaxis().getId(), newPlot.getYaxis().getId());
                nameMap.put(p.getZaxis().getId(), newPlot.getZaxis().getId());
            }
            Application dom = controller.getApplication();
            for (int i3 = 0; i3 < state.getBindings().length; ++i3) {
                BindingModel bm = state.getBindings(i3);
                String newSrc = (String)nameMap.get(bm.getSrcId());
                String newDst = (String)nameMap.get(bm.getDstId());
                DomNode src = dom.getController().getElementById(newSrc);
                DomNode dst = dom.getController().getElementById(newDst);
                controller.bind(src, bm.getSrcProperty(), dst, bm.getDstProperty());
            }
            boolean bl = doBindX = dom.getController().findBindings(dom, "timeRange").size() > 0 && dom.getController().findBindings(targetPlot, "context").isEmpty() && UnitsUtil.isTimeLocation((Units)targetPlot.getXaxis().getRange().getUnits()) && UnitsUtil.isTimeLocation((Units)dom.getTimeRange().getUnits());
            if (doBindX) {
                targetPlot.getXaxis().setRange(dom.getTimeRange());
                controller.getApplication().getController().bind(dom, "timeRange", targetPlot.getXaxis(), "range");
            } else if (dom.getController().findBindings(dom, "timeRange", targetPlot, "context").size() == 1 && UnitsUtil.isTimeLocation((Units)targetPlot.getXaxis().getRange().getUnits())) {
                dom.setTimeRange(targetPlot.getXaxis().getRange());
                controller.getApplication().getController().unbind(dom, "timeRange", targetPlot, "context");
                controller.getApplication().getController().bind(dom, "timeRange", targetPlot.getXaxis(), "range");
            }
            for (i = 0; i < state.getDataSourceFilters().length; ++i) {
                DataSourceFilter newDsf = controller.addDataSourceFilter();
                DataSourceFilter stateDsf = state.getDataSourceFilters(i);
                if (!stateDsf.getUri().startsWith("vap+internal:")) {
                    newDsf.syncTo(state.getDataSourceFilters(i), Collections.singletonList("id"));
                    state.setDataSourceFilters(i, null);
                }
                nameMap.put(stateDsf.getId(), newDsf.getId());
            }
            for (i = 0; i < state.getDataSourceFilters().length; ++i) {
                DataSourceFilter stateDsf = state.getDataSourceFilters(i);
                if (stateDsf == null) continue;
                String uri = stateDsf.getUri();
                String[] children = uri.substring(13).split(",");
                StringBuilder sb = new StringBuilder("vap+internal:");
                for (int j = 0; j < children.length; ++j) {
                    if (j > 0) {
                        sb.append(",");
                    }
                    sb.append((String)nameMap.get(children[j]));
                }
                stateDsf.setUri(sb.toString());
                DataSourceFilter newDsf = (DataSourceFilter)DomUtil.getElementById(controller.getApplication(), (String)nameMap.get(stateDsf.getId()));
                newDsf.syncTo(stateDsf, Collections.singletonList("id"));
            }
            Application theApp = controller.getApplication();
            for (int i4 = 0; i4 < state.getPlotElements().length; ++i4) {
                PlotElement pe2;
                PlotElement pe1 = state.getPlotElements(i4);
                DataSourceFilter dsf1 = (DataSourceFilter)DomUtil.getElementById(theApp, (String)nameMap.get(pe1.getDataSourceFilterId()));
                Plot plot1 = (Plot)DomUtil.getElementById(theApp, (String)nameMap.get(pe1.getPlotId()));
                List<PlotElement> recyclePes = controller.getPlotElementsFor(plot1);
                if (i4 < recyclePes.size()) {
                    pe2 = recyclePes.get(i4);
                    pe2.setDataSourceFilterId(dsf1.getId());
                    pe2.setPlotId(plot1.getId());
                } else {
                    pe2 = controller.addPlotElement(plot1, dsf1);
                }
                pe2.syncTo(pe1, Arrays.asList("id", "plotId", "dataSourceFilterId"));
                if (i4 == 0) {
                    plot1.setAutoBinding(true);
                    plot1.getController().setAutoBinding(true);
                }
                pe2.getController().setResetPlotElement(false);
                pe2.getController().setResetRanges(false);
            }
        }
        finally {
            controller.changePerformed(app, lockObject);
            lock.unlock();
        }
    }

    public static void pasteClipboardPlotElementsIntoPlot(Component app, ApplicationController controller, Plot targetPlot) {
        try {
            Application state;
            String s;
            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (clpbrd.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                s = (String)clpbrd.getData(DataFlavor.stringFlavor);
                if (!GuiSupport.isStringVap(s)) {
                    JOptionPane.showMessageDialog(app, "<html>Use \"Edit Plot\"->\"Copy Plot to Clipboard\"<br>(Pasted content should be XML.)");
                    return;
                }
            } else {
                JOptionPane.showMessageDialog(app, "<html>Use \"Edit Plot\"->\"Copy Plot to Clipboard\"<br>(Content should be a string.)");
                return;
            }
            try {
                state = (Application)StatePersistence.restoreState(new ByteArrayInputStream(s.getBytes()));
            }
            catch (IllegalArgumentException ex) {
                JOptionPane.showMessageDialog(app, "<html>Use \"Edit Plot\"->\"Copy Plot to Clipboard\"<br>(" + ex.getMessage() + ")");
                return;
            }
            PlotElement[] pes = state.getPlotElements();
            JPanel panel = new JPanel();
            JCheckBox[] cbs = new JCheckBox[pes.length];
            GridLayout gl = new GridLayout(pes.length, 2);
            panel.setLayout(gl);
            for (int i = 0; i < pes.length; ++i) {
                Icon icon = GraphicsUtil.guessIconFor(pes[i]);
                cbs[i] = new JCheckBox("", true);
                panel.add(cbs[i]);
                if (icon != null) {
                    JLabel x = new JLabel(pes[i].getRenderType().toString());
                    x.setIcon(icon);
                    panel.add(x);
                    continue;
                }
                panel.add(new JLabel(pes[i].getRenderType().toString()));
            }
            if (JOptionPane.showConfirmDialog(app, panel, "Add Plot Elements", 2) == 0) {
                boolean[] selected = new boolean[pes.length];
                for (int i = 0; i < pes.length; ++i) {
                    selected[i] = cbs[i].isSelected();
                }
                GuiSupport.doPasteClipboardPlotElementsIntoPlot(app, controller, state, pes, selected, targetPlot);
            }
        }
        catch (UnsupportedFlavorException | IOException ex) {
            Logger.getLogger(GuiSupport.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doPasteClipboardPlotElementsIntoPlot(Object client, ApplicationController controller, Application state, PlotElement[] pes, boolean[] selected, Plot targetPlot) {
        String lockObject = "addPlotElements";
        controller.registerPendingChange(client, lockObject);
        ChangesSupport.DomLock lock = controller.mutatorLock();
        try {
            int i;
            lock.lock("pasting plot elements");
            controller.performingChange(client, lockObject);
            HashMap<String, String> nameMap = new HashMap<String, String>();
            for (i = 0; i < state.getDataSourceFilters().length; ++i) {
                DataSourceFilter stateDsf = state.getDataSourceFilters(i);
                List<PlotElement> pes1 = DomUtil.getPlotElementsFor(state, stateDsf);
                boolean inUse = false;
                for (PlotElement pe1 : pes1) {
                    for (int j = 0; j < pes.length; ++j) {
                        if (pes[j] != pe1 || !selected[j]) continue;
                        inUse = true;
                    }
                }
                if (!inUse) continue;
                DataSourceFilter newDsf = controller.addDataSourceFilter();
                if (!stateDsf.getUri().startsWith("vap+internal:")) {
                    newDsf.syncTo(stateDsf, Collections.singletonList("id"));
                    state.setDataSourceFilters(i, null);
                }
                nameMap.put(stateDsf.getId(), newDsf.getId());
            }
            for (i = 0; i < pes.length; ++i) {
                if (!selected[i]) continue;
                PlotElement peNew = controller.addPlotElement(targetPlot, null, null);
                peNew.syncTo(pes[i], Arrays.asList("id", "plotId", "dataSourceFilterId"));
                String mappedName = (String)nameMap.get(pes[i].getDataSourceFilterId());
                if (mappedName != null) {
                    peNew.setDataSourceFilterId(mappedName);
                } else {
                    logger.warning("no DSF ID mapping--something has gone horribly wrong.");
                }
                peNew.getController().setResetPlotElement(false);
                peNew.getController().setResetRanges(false);
            }
        }
        finally {
            controller.changePerformed(client, lockObject);
            lock.unlock();
        }
    }

    static void addPlotContextMenuItems(final AutoplotUI app, final ApplicationController controller, final DasPlot plot, final PlotController plotController, final Plot domPlot) {
        plot.getDasMouseInputAdapter().addMouseModule(new MouseModule((DasCanvasComponent)plot, (DragRenderer)new PointSlopeDragRenderer((DasCanvasComponent)plot, plot.getXAxis(), plot.getYAxis()), "Slope"));
        plot.getDasMouseInputAdapter().removeMenuItem("Dump Data");
        plot.getDasMouseInputAdapter().removeMenuItem("Properties");
        ArrayList<JMenuItem> expertMenuItems = new ArrayList<JMenuItem>();
        JMenuItem mi = new JMenuItem(new AbstractAction("Plot Properties"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                PropertyEditor pp = new PropertyEditor((Object)domPlot);
                pp.showDialog((Component)plot.getCanvas());
            }
        });
        plot.getDasMouseInputAdapter().addMenuItem((Component)mi);
        expertMenuItems.add(mi);
        mi = new JMenuItem(new AbstractAction("Plot Element Properties"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                PlotElement p = controller.getPlotElement();
                PropertyEditor pp = new PropertyEditor((Object)p);
                pp.showDialog((Component)plot.getCanvas());
            }
        });
        plot.getDasMouseInputAdapter().addMenuItem((Component)mi);
        expertMenuItems.add(mi);
        JMenuItem panelPropsMenuItem = new JMenuItem(new AbstractAction("Plot Element Style Properties"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                PlotElement p = controller.getPlotElement();
                PlotElement oldP = (PlotElement)p.copy();
                PlotStylePanel.StylePanel editorPanel = GuiSupport.getStylePanel(p.getRenderType());
                editorPanel.doElementBindings(p);
                if (2 == AutoplotUtil.showConfirmDialog(app, editorPanel, (Object)((Object)p.getRenderType()) + " Style", 2)) {
                    p.syncTo(oldP);
                }
            }
        });
        plotController.setPlotElementPropsMenuItem(panelPropsMenuItem);
        plot.getDasMouseInputAdapter().addMenuItem((Component)panelPropsMenuItem);
        expertMenuItems.add(panelPropsMenuItem);
        plot.getDasMouseInputAdapter().addMenuItem((Component)new JSeparator());
        final JMenu ezMenu = GuiSupport.createEZAccessMenu(domPlot);
        ezMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                PlotElement pe = app.dom.getController().getPlotElement();
                if (pe == null) {
                    return;
                }
                QDataSet ds = pe.getController().getDataSet();
                Map tt = GuiSupport.getRenderTypeForString();
                for (int i = 0; i < ezMenu.getItemCount(); ++i) {
                    if (!(ezMenu.getItem(i) instanceof JCheckBoxMenuItem)) continue;
                    JCheckBoxMenuItem mi = (JCheckBoxMenuItem)ezMenu.getItem(i);
                    RenderType rt = (RenderType)((Object)tt.get(mi.getText()));
                    if (rt.equals((Object)pe.getRenderType())) {
                        mi.setSelected(true);
                    } else {
                        mi.setSelected(false);
                    }
                    if (pe.getController().getParentPlotElement() != null) {
                        ds = pe.getController().getParentPlotElement().getController().getDataSet();
                        if (ds == null || RenderType.acceptsData(rt, ds)) {
                            mi.setEnabled(true);
                            continue;
                        }
                        mi.setEnabled(false);
                        continue;
                    }
                    if (ds == null || RenderType.acceptsData(rt, ds)) {
                        mi.setEnabled(true);
                        continue;
                    }
                    mi.setEnabled(false);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        plot.getDasMouseInputAdapter().addMenuItem((Component)ezMenu);
        expertMenuItems.add(ezMenu);
        JMenu addPlotMenu = new JMenu("Add Plot");
        plot.getDasMouseInputAdapter().addMenuItem((Component)addPlotMenu);
        JMenuItem item = new JMenuItem(new AbstractAction("Copy Plot Elements Down"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        Plot newPlot = controller.copyPlotAndPlotElements(domPlot, null, false, false);
                        Application dom = domPlot.getController().getApplication();
                        List<BindingModel> bms = dom.getController().findBindings(dom, "timeRange", domPlot.getXaxis(), "range");
                        if (bms.size() > 0 && UnitsUtil.isTimeLocation((Units)newPlot.getXaxis().getRange().getUnits())) {
                            controller.bind(controller.getApplication(), "timeRange", newPlot.getXaxis(), "range");
                        }
                    }
                };
                new Thread(run, "copyPlotElementsDown").start();
            }
        });
        item.setToolTipText("make a new plot below, and copy the plot elements into it.  New plot is bound by the x axis.");
        addPlotMenu.add(item);
        item = new JMenuItem(new AbstractAction("Paste Plot From Clipboard"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Plot newP = controller.addPlot(domPlot, LayoutConstants.BELOW);
                GuiSupport.pasteClipboardIntoPlot(app, controller, newP);
            }
        });
        item.setToolTipText("Paste the plot in the system clipboard.");
        addPlotMenu.add(item);
        item = new JMenuItem(new AbstractAction("Add Inset Plot"){

            @Override
            public void actionPerformed(ActionEvent e) {
                controller.addPlot("50%,100%-2em", "2em,50%");
            }
        });
        item.setToolTipText("Add a plot at an arbitrary position.");
        addPlotMenu.add(item);
        item = new JMenuItem(new AbstractAction("Add Right Axis Plot"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Plot p = controller.addPlot(domPlot, null);
                PlotElement pe = controller.addPlotElement(p, null);
                logger.log(Level.FINE, "created new plotElement: {0}", pe);
                p.getYaxis().setOpposite(true);
                controller.bind(domPlot.getXaxis(), "range", p.getXaxis(), "range");
            }
        });
        item.setToolTipText("Add a plot in the same position but with its own axis on right side.");
        addPlotMenu.add(item);
        item = new JMenuItem(new AbstractAction("Context Overview"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        domPlot.getController().contextOverview();
                    }
                };
                new Thread(run, "contextOverview").start();
            }
        });
        item.setToolTipText("make a new plot, and copy the plot elements into it.  The plot is not bound,\nand a connector is drawn between the two.  The panel uris are bound as well.");
        addPlotMenu.add(item);
        item = new JMenuItem(new AbstractAction("New Location (URI)..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        app.dom.getController().setPlot(domPlot);
                        app.support.addPlotElement("New Location (URI)");
                    }
                };
                SwingUtilities.invokeLater(run);
            }
        });
        item.setToolTipText("change URI or add plot");
        addPlotMenu.add(item);
        expertMenuItems.add(addPlotMenu);
        JMenu editPlotMenu = new JMenu("Edit Plot");
        plot.getDasMouseInputAdapter().addMenuItem((Component)editPlotMenu);
        controller.fillEditPlotMenu(editPlotMenu, domPlot);
        expertMenuItems.add(editPlotMenu);
        JMenu panelMenu = new JMenu("Edit Plot Element");
        plot.getDasMouseInputAdapter().addMenuItem((Component)panelMenu);
        expertMenuItems.add(panelMenu);
        item = new JMenuItem(new AbstractAction("Move to Plot Above"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                PlotElement pelement = controller.getPlotElement();
                Plot plot = controller.getPlotFor(pelement);
                Plot dstPlot = controller.getPlotAbove(plot);
                if (dstPlot == null) {
                    dstPlot = controller.addPlot(LayoutConstants.ABOVE);
                    pelement.setPlotId(dstPlot.getId());
                } else {
                    pelement.setPlotId(dstPlot.getId());
                }
            }
        });
        panelMenu.add(item);
        expertMenuItems.add(panelMenu);
        item = new JMenuItem(new AbstractAction("Insert New Plot Above"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                PlotElement pelement = controller.getPlotElement();
                Plot dstPlot = controller.addPlot(LayoutConstants.ABOVE);
                pelement.setPlotId(dstPlot.getId());
            }
        });
        panelMenu.add(item);
        expertMenuItems.add(panelMenu);
        item = new JMenuItem(new AbstractAction("Insert New Plot Below"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                PlotElement pelement = controller.getPlotElement();
                Plot dstPlot = controller.addPlot(LayoutConstants.BELOW);
                pelement.setPlotId(dstPlot.getId());
            }
        });
        panelMenu.add(item);
        expertMenuItems.add(panelMenu);
        item = new JMenuItem(new AbstractAction("Move to Plot Below"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                PlotElement pelement = controller.getPlotElement();
                Plot plot = controller.getPlotFor(pelement);
                Plot dstPlot = controller.getPlotBelow(plot);
                if (dstPlot == null) {
                    dstPlot = controller.addPlot(LayoutConstants.BELOW);
                    pelement.setPlotId(dstPlot.getId());
                    controller.bind(plot.getXaxis(), "range", dstPlot.getXaxis(), "range");
                } else {
                    pelement.setPlotId(dstPlot.getId());
                }
            }
        });
        panelMenu.add(item);
        expertMenuItems.add(item);
        item = new JMenuItem(new AbstractAction("Delete Plot Element"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                PlotElement pelement = controller.getPlotElement();
                if (controller.getApplication().getPlotElements().length < 2) {
                    DataSourceFilter dsf = controller.getDataSourceFilterFor(controller.getApplication().getPlotElements(0));
                    dsf.setUri("");
                    pelement.setLegendLabelAutomatically("");
                    pelement.setActive(true);
                    return;
                }
                controller.deletePlotElement(pelement);
            }
        });
        panelMenu.add(item);
        expertMenuItems.add(item);
        item = new JMenuItem(new AbstractAction("Move Plot Element Below Others"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                PlotElement pelement = controller.getPlotElement();
                Plot p = pelement.getController().getApplication().getController().getPlotFor(pelement);
                p.getController().toBottom(pelement);
            }
        });
        panelMenu.add(item);
        expertMenuItems.add(item);
        JMenuItem editDataMenu = new JMenuItem(new AbstractAction("Edit Data Source"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                GuiSupport.editPlotElement(controller.getApplicationModel(), (Component)plot);
            }
        });
        expertMenuItems.add(editDataMenu);
        plot.getDasMouseInputAdapter().addMenuItem((Component)editDataMenu);
        plot.getDasMouseInputAdapter().addMenuItem((Component)new JSeparator());
        plot.getDasMouseInputAdapter().addMenuItem((Component)new JMenuItem(new AbstractAction("Reset Zoom"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                plotController.resetZoom(true, true, true);
            }
        }));
        plot.getDasMouseInputAdapter().addMenuItem((Component)new JMenuItem(new AbstractAction("Add Annotation..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                AnnotationEditorPanel p = new AnnotationEditorPanel();
                Annotation ann = new Annotation();
                ann.setPlotId(domPlot.getId());
                Datum datax = plot.getXAxis().invTransform((double)plot.getDasMouseInputAdapter().getMousePressPositionOnCanvas().x);
                Datum datay = plot.getYAxis().invTransform((double)plot.getDasMouseInputAdapter().getMousePressPositionOnCanvas().y);
                ann.setPointAtX(datax);
                ann.setPointAtY(datay);
                ann.setXrange(DatumRange.newRange((Datum)datax, (Datum)datax));
                ann.setYrange(DatumRange.newRange((Datum)datay, (Datum)datay));
                p.doBindings(ann);
                if (0 == AutoplotUtil.showConfirmDialog(app, p, "Add Annotation", 2)) {
                    controller.addAnnotation(ann);
                }
            }
        }));
        plot.getDasMouseInputAdapter().addMenuItem((Component)new JSeparator());
        plotController.setExpertMenuItems(expertMenuItems.toArray(new JMenuItem[expertMenuItems.size()]));
        plot.getDasMouseInputAdapter().setMenuLabel(domPlot.getId());
    }

    protected void doInspectVap() {
        Preferences prefs = AutoplotSettings.settings().getPreferences(AutoplotSettings.class);
        String currentDirectory = prefs.get("last_open_vap_folder", prefs.get("last_open_folder", new File(System.getProperty("user.home")).toString()));
        String lcurrentFile = prefs.get("last_open_vap_file", "");
        JFileChooser chooser = new JFileChooser(currentDirectory);
        if (lcurrentFile.length() > 0) {
            chooser.setSelectedFile(new File(lcurrentFile));
        }
        FileNameExtensionFilter ff = new FileNameExtensionFilter("vap files", "vap");
        chooser.addChoosableFileFilter(ff);
        chooser.setFileFilter(ff);
        if (0 == chooser.showOpenDialog(this.parent)) {
            try {
                final File f = chooser.getSelectedFile();
                prefs.put("last_open_vap_folder", f.getParent());
                prefs.put("last_open_vap_file", f.toString());
                final Application vap = (Application)StatePersistence.restoreState(f);
                PropertyEditor edit = new PropertyEditor((Object)vap);
                edit.addSaveAction(new AbstractAction("Save"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoggerManager.logGuiEvent((ActionEvent)e);
                        try {
                            StatePersistence.saveState(f, vap);
                        }
                        catch (IOException ex) {
                            JOptionPane.showConfirmDialog(GuiSupport.this.parent, "Unable to save to file: " + f);
                        }
                    }
                });
                edit.showDialog((Component)this.parent);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
                JOptionPane.showMessageDialog(this.parent, "File does not appear to well-formatted .vap file");
            }
        }
    }

    public static Font pickFont(Frame parent, ApplicationModel app) {
        FontChooser chooser = new FontChooser();
        String sci = Entities.decodeEntities((String)"2 &times; 10E7  &aacute;");
        String greek = Entities.decodeEntities((String)"Greek Symbols: &Delta; &alpha; &beta; &delta; &pi; &rho; &omega;");
        String math = Entities.decodeEntities((String)"Math Symbols: &sum; &plusmn;");
        chooser.setExampleText("Electron Differential Energy Flux\n2001-01-10 12:00\nExtended ASCII: " + sci + "\n" + greek + "\n" + math);
        chooser.setCurrentFont(app.getCanvas().getBaseFont());
        JOptionPane p = new JOptionPane(chooser, -1, 2);
        JDialog dialog = p.createDialog("Pick Font");
        dialog.setResizable(true);
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        if ((Integer)p.getValue() == 0) {
            return GuiSupport.setFont(app, chooser.getCurrentFont());
        }
        return null;
    }

    public static Font setFont(ApplicationModel app, Font nf) {
        app.getCanvas().setBaseFont(nf);
        Font f = app.getCanvas().getFont();
        app.getDocumentModel().getOptions().setCanvasFont(DomUtil.encodeFont(f));
        return f;
    }

    public static void raiseApplicationWindow(Frame frame) {
        frame.setVisible(true);
        int state = frame.getExtendedState();
        frame.setExtendedState(state &= 0xFFFFFFFE);
        frame.setAlwaysOnTop(true);
        frame.toFront();
        frame.requestFocus();
        frame.setAlwaysOnTop(false);
    }

    public static MouseAdapter createExamplesPopup(final JTextField tf, final String[] labels, final String[] tooltips) {
        return new MouseAdapter(){

            private JMenuItem createMenuItem(final JTextField componentTextField, final String insert, String doc) {
                JMenuItem result = new JMenuItem(new AbstractAction(insert){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoggerManager.logGuiEvent((ActionEvent)e);
                        String v = componentTextField.getText();
                        int i = componentTextField.getCaretPosition();
                        componentTextField.setText(v.substring(0, i) + insert + v.substring(i));
                    }
                });
                if (doc != null) {
                    result.setToolTipText(doc);
                }
                return result;
            }

            void showPopup(MouseEvent ev) {
                JPopupMenu processMenu = new JPopupMenu();
                for (int i = 0; i < labels.length; ++i) {
                    processMenu.add(this.createMenuItem(tf, labels[i], tooltips == null ? null : tooltips[i]));
                }
                processMenu.show(ev.getComponent(), ev.getX(), ev.getY());
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    this.showPopup(evt);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    this.showPopup(evt);
                }
            }
        };
    }
}

